uniform sampler2D texTo;
uniform sampler2D texFrom;
uniform sampler2D texCloud;

uniform float crossfader;
uniform float randomSeed;
uniform float levelFrom;
uniform float levelTo;

void main()
{
	vec2 uv = gl_TexCoord[0].st;
  vec4 color = gl_Color;

  float offset = min(crossfader + crossfader * texture2D(texCloud, vec2(uv.x, randomSeed)).r, 1.0);
  uv.y -= offset;
    
  if(uv.y > 0.0)
  {
		color = texture2D(texFrom, uv.xy);
    color.a = levelFrom;
  }
  else 
  {
    color = texture2D(texTo, uv.xy);
    color.a = levelTo;
  }
  gl_FragColor = color;
}